/**
 *
 * xpt -- An X Periodic Table
 *
 * xpt.h -- some necessary global variables, data types, and LOTS of info
 *
 * Written by Joel P. Lord 03/05/93
 *
 *    This software is available for free distribution,
 * under the condition that this not be removed from the
 * source code.
 *
**/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#ifdef __VMS
#include <X11/Xext.h>
#else
#include <X11/extensions/Xext.h>
#endif
#ifdef HAVE_LIB_XAW3DXFT
#include <X11/Xaw3dxft/XawInit.h>
#include <X11/Xaw3dxft/Simple.h>
#include <X11/Xaw3dxft/Command.h>
#include <X11/Xaw3dxft/Command.h>
#include <X11/Xaw3dxft/Box.h>
#include <X11/Xaw3dxft/Form.h>
#include <X11/Xaw3dxft/Dialog.h>
#include <X11/Xaw3dxft/Scrollbar.h>
#include <X11/Xaw3dxft/List.h>
#include <X11/Xaw3dxft/Label.h>
#elif defined(HAVE_LIB_XAW3D)
#ifdef __VMS
#include <Xaw3d/XawInit.h>
#include <Xaw3d/Simple.h>
#include <Xaw3d/Command.h>
#include <Xaw3d/Command.h>
#include <Xaw3d/Box.h>
#include <Xaw3d/Form.h>
#include <Xaw3d/Dialog.h>
#include <Xaw3d/Scrollbar.h>
#include <Xaw3d/List.h>
#include <Xaw3d/Label.h>
#else
#include <X11/Xaw3d/XawInit.h>
#include <X11/Xaw3d/Simple.h>
#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Box.h>
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/Dialog.h>
#include <X11/Xaw3d/Scrollbar.h>
#include <X11/Xaw3d/List.h>
#include <X11/Xaw3d/Label.h>
#endif
#elif defined(HAVE_LIB_NEXTAW)
#include <X11/neXtaw/XawInit.h>
#include <X11/neXtaw/Simple.h>
#include <X11/neXtaw/Command.h>
#include <X11/neXtaw/Command.h>
#include <X11/neXtaw/Box.h>
#include <X11/neXtaw/Form.h>
#include <X11/neXtaw/Dialog.h>
#include <X11/neXtaw/Scrollbar.h>
#include <X11/neXtaw/List.h>
#include <X11/neXtaw/Label.h>
#elif defined(HAVE_LIB_XAWPLUS)
#include <X11/XawPlus/XawInit.h>
#include <X11/XawPlus/Simple.h>
#include <X11/XawPlus/Command.h>
#include <X11/XawPlus/Command.h>
#include <X11/XawPlus/Box.h>
#include <X11/XawPlus/Form.h>
#include <X11/XawPlus/Dialog.h>
#include <X11/XawPlus/Scrollbar.h>
#include <X11/XawPlus/List.h>
#include <X11/XawPlus/Label.h>
#elif defined(HAVE_ATHENA) /* HAVE_LIB_XAW */
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Label.h>
#endif
#include "Xprogs.h"
#include "fontlist.h"
#include "version.h"

struct element_stats {
  double        atomic_radius;
  double        covalent_radius;
  unsigned      atomic_number;
  double        atomic_mass;
  char          symbol[4];
  double	boiling_pt;
  double	melting_pt;
  double	density;
  double	atomic_volume;
  char		name[14];
  char		valence[256];
};

#ifdef MAIN

Widget toplevel, MainW;
int done;
Colormap default_cmap;
unsigned long red, white, slate_grey;
XFontStruct *BigFont;
GC BigGC;

struct element_stats p_table[] = {
0.79, 0.32,   1, 1.00794    , "H  ", 20.268, 14.025 , 0.0899 , 14.4 ,
  "Hydrogen     ","1s1 ",
0.49, 0.93,   2, 4.002602   , "He ", 4.215 , 0.95   , 0.1787 , 0.0  ,
  "Helium       ","1s2 ",
2.05, 1.23,   3, 6.941      , "Li ", 1615  , 453.7  , 0.53   , 13.10,
  "Lithium      ","[He]2s1 ",
1.40, 0.90,   4, 9.012182   , "Be ", 2745  , 1560.0 , 1.85   , 5.0  ,
  "Beryllium    ","[He]2s2 ",
1.17, 0.82,   5, 10.811     , "B  ", 4275  , 2300.0 , 2.34   , 4.6  ,
  "Boron        ","[He]2s2_2p1 ",
0.91, 0.77,   6, 12.011     , "C  ", 4470.0, 4100.0 , 2.62   , 4.58 ,
  "Carbon       ","[He]2s2_2p2 ",
0.75, 0.75,   7, 14.00674   , "N  ", 77.35 , 63.14  , 1.251  , 17.3 ,
  "Nitrogen     ","[He]2s2_2p3 ",
0.65, 0.73,   8, 15.9994    , "O  ", 90.18 , 50.35  , 1.429  , 14.0 ,
  "Oxygen       ","[He]2s2_2p4 ",
0.57, 0.72,   9, 18.9984032 , "F  ", 84.95 , 53.48  , 1.696  , 17.1 ,
  "Fluorine     ","[He]2s2_2p5 ",
0.51, 0.71,  10, 20.1797    , "Ne ", 27.096, 24.553 , 0.901  , 16.7 ,
  "Neon         ","[He]2s2_2p6 ",
2.23, 1.54,  11, 22.989768  , "Na ", 1156  , 371.0  , 0.97   , 23.7 ,
  "Sodium       ","[Ne]3s1 ",
1.72, 1.36,  12, 24.3050    , "Mg ", 1363  , 922    , 1.74   , 13.97,
  "Magnesium    ","[Ne]3s2 ",
1.82, 1.18,  13, 26.981539  , "Al ", 2793  , 933.25 , 2.70   , 10.0 ,
  "Aluminum     ","[Ne]3s2_3p1 ",
1.46, 1.11,  14, 28.0855    , "Si ", 3540.0, 1685   , 2.33   , 12.1 ,
  "Silicon      ","[Ne]3s2_3p2 ",
1.23, 1.06,  15, 30.97362   , "P  ", 550.0 , 317.30 , 1.82   , 17.0 ,
  "Phosphorus   ","[Ne]3s2_3p3 ",
1.09, 1.02,  16, 32.066     , "S  ", 717.75, 388.36 , 2.07   , 15.5 ,
  "Sulfur       ","[Ne]3s2_3p4 ",
0.97, 0.99,  17, 35.4527    , "Cl ", 239.1 , 172.16 , 3.17   , 22.7 ,
  "Chlorine     ","[Ne]3s2_3p5 ",
0.88, 0.98,  18, 39.948     , "Ar ", 87.30 , 83.81  , 1.784  , 28.5 ,
  "Argon        ","[Ne]3s2_3p6 ",
2.77, 2.03,  19, 39.0983    , "K  ", 1032  , 336.35 , 0.86   , 45.46,
  "Potassium    ","[Ar]4s1 ",
2.23, 1.91,  20, 40.078     , "Ca ", 1757  , 1112   , 1.55   , 29.9 ,
  "Calcium      ","[Ar]4s2 ",
2.09, 1.62,  21, 44.955910  , "Sc ", 3104  , 1812   , 3.0    , 15.0 ,
  "Scandium     ","[Ar]4s2_3d1 ",
2.00, 1.45,  22, 47.88      , "Ti ", 3562  , 1943   , 4.50   , 10.64,
  "Titanium     ","[Ar]4s2_3d2 ",
1.92, 1.34,  23, 50.9415    , "V  ", 3682  , 2175   , 5.8    , 8.78 ,
  "Vanadium     ","[Ar]4s2_3d3 ",
1.85, 1.18,  24, 51.9961    , "Cr ", 2945  , 2130.0 , 7.19   , 7.23 ,
  "Chromium     ","[Ar]4s1_3d5 ",
1.79, 1.17,  25, 54.93085   , "Mn ", 2335  , 1517   , 7.43   , 1.39 ,
  "Manganese    ","[Ar]4s2_3d5 ",
1.72, 1.17,  26, 55.847     , "Fe ", 3135  , 1809   , 7.86   , 7.1  ,
  "Iron         ","[Ar]4s2_3d6 ",
1.67, 1.16,  27, 58.93320   , "Co ", 3201  , 1768   , 8.90   , 6.7  ,
  "Cobalt       ","[Ar]4s2_3d7 ",
1.62, 1.15,  28, 58.69      , "Ni ", 3187  , 1726   , 8.90   , 6.59 ,
  "Nickel       ","[Ar]4s2_3d8 ",
1.57, 1.17,  29, 63.546     , "Cu ", 2836  , 1357.6 , 8.96   , 7.1  ,
  "Copper       ","[Ar]4s1_3d10 ",
1.53, 1.25,  30, 65.39      , "Zn ", 1180.0, 692.73 , 7.14   , 9.2  ,
  "Zinc         ","[Ar]4s2_3d10 ",
1.81, 1.26,  31, 69.723     , "Ga ", 2478  , 302.90 , 5.91   , 11.8 ,
  "Gallium      ","[Ar]4s2_3d10_4p1 ",
1.52, 1.22,  32, 72.61      , "Ge ", 3107  , 1210.4 , 5.32   , 13.6 ,
  "Germanium    ","[Ar]4s2_3d10_4p2 ",
1.33, 1.20,  33, 74.92159   , "As ", 876   , 1081   , 5.72   , 13.1 ,
  "Arsenic      ","[Ar]4s2_3d10_4p3 ",
1.22, 1.16,  34, 78.96      , "Se ", 958   , 494    , 4.80   , 16.45,
  "Selenium     ","[Ar]4s2_3d10_4p4 ",
1.12, 1.14,  35, 79.904     , "Br ", 332.25, 265.90 , 3.12   , 23.5 ,
  "Bromine      ","[Ar]4s2_3d10_4p5 ",
1.03, 1.12,  36, 83.80      , "Kr ", 119.80, 115.78 , 3.74   , 38.9 ,
  "Krypton      ","[Ar]4s2_3d10_4p6 ",
2.98, 2.16,  37, 85.4678    , "Rb ", 961   , 312.64 , 1.53   , 55.9 ,
  "Rubidium     ","[Kr]5s1 ",
2.45, 1.91,  38, 87.62      , "Sr ", 1650.0, 1041   , 2.6    , 33.7 ,
  "Strontium    ","[Kr]5s2 ",
2.27, 1.62,  39, 88.90585   , "Y  ", 3611  , 1799   , 4.5    , 19.8 ,
  "Yttrium      ","[Kr]5s2_4d1 ",
2.16, 1.45,  40, 91.224     , "Zr ", 4682  , 2125   , 6.49   , 14.1 ,
  "Zirconium    ","[Kr]5s2_4d2 ",
2.09, 1.34,  41, 92.90638   , "Nb ", 5017  , 2740.0 , 8.55   , 10.87,
  "Niobium      ","[Kr]5s1_4d4 ",
2.01, 1.30,  42, 95.94      , "Mo ", 4912  , 2890.0 , 10.2   , 9.4  ,
  "Molybdenum   ","[Kr]5s1_4d5 ",
1.95, 1.27,  43, 98         , "Tc ", 4538  , 2473   , 11.5   , 8.5  ,
  "Technetium   ","[Kr]5s2_4d5 ",
1.89, 1.25,  44, 101.07     , "Ru ", 4423  , 2523   , 12.2   , 8.3  ,
  "Ruthenium    ","[Kr]5s1_4d7 ",
1.83, 1.25,  45, 102.90550  , "Rh ", 3970.0, 2236   , 12.4   , 8.3  ,
  "Rhodium      ","[Kr]5s1_4d8 ",
1.79, 1.28,  46, 106.42     , "Pd ", 3237  , 1825   , 12.0   , 8.9  ,
  "Palladium    ","[Kr]4d10 ",
1.75, 1.34,  47, 107.8682   , "Ag ", 2436  , 1234   , 10.5   , 10.3 ,
  "Silver       ","[Kr]5s1_4d10 ",
1.71, 1.48,  48, 112.411    , "Cd ", 1040.0, 594.18 , 8.65   , 13.1 ,
  "Cadmium      ","[Kr]5s2_4d10 ",
2.00, 1.44,  49, 114.82     , "In ", 2346  , 429.76 , 7.31   , 15.7 ,
  "Indium       ","[Kr]5s2_4d10_5p1 ",
1.72, 1.41,  50, 118.710    , "Sn ", 2876  , 505.06 , 7.30   , 16.3 ,
  "Tin          ","[Kr]5s2_4d10_5p2 ",
1.53, 1.40,  51, 121.75     , "Sb ", 1860.0, 904    , 6.68   , 18.23,
  "Antimony     ","[Kr]5s2_4d10_5p3 ",
1.42, 1.36,  52, 127.60     , "Te ", 1261  , 722.65 , 6.24   , 20.5 ,
  "Tellurium    ","[Kr]5s2_4d10_5p4 ",
1.32, 1.33,  53, 126.90447  , "I  ", 458.4 , 386.7  , 4.92   , 25.74,
  "Iodine       ","[Kr]5s2_4d10_5p5 ",
1.24, 1.31,  54, 131.29     , "Xe ", 165.03, 161.36 , 5.89   , 37.3 ,
  "Xenon        ","[Kr]5s2_4d10_5p6 ",
3.34, 2.35,  55, 132.90543  , "Cs ", 944   , 301.55 , 1.87   , 71.07,
  "Cesium       ","[Xe]6s1 ",
2.78, 1.98,  56, 137.327    , "Ba ", 2171  , 1002   , 3.5    , 39.24,
  "Barium       ","[Xe]6s2 ",
2.74, 1.69,  57, 138.9055   , "La ", 3730.0, 1193   , 6.7    , 20.73,
  "Lanthanum    ","[Xe]6s2_5d1 ",
2.16, 1.44,  72, 178.49     , "Hf ", 4876  , 2500.0 , 13.1   , 13.6 ,
  "Hafnium      ","[Xe]6s2_5d2_4f14 ",
2.09, 1.34,  73, 180.9479   , "Ta ", 5731  , 3287   , 16.6   , 10.90,
  "Tantalum     ","[Xe]6s2_5d3 4f14 ",
2.02, 1.30,  74, 183.85     , "W  ", 5828  , 3680.0 , 19.3   , 9.53 ,
  "Tungsten     ","[Xe]6s2_5d4 4f14 ",
1.97, 1.28,  75, 186.207    , "Re ", 5869  , 3453   , 21.0   , 8.85 ,
  "Rhenium      ","[Xe]6s2_5d5 4f14 ",
1.92, 1.26,  76, 190.2      , "Os ", 5285  , 3300.0 , 22.4   , 8.49 ,
  "Osmium       ","[Xe]6s2_5d6 4f14 ",
1.87, 1.27,  77, 192.22     , "Ir ", 4701  , 2716   , 22.5   , 8.54 ,
  "Iridium      ","[Xe]6s2_5d7 4f14 ",
1.83, 1.30,  78, 195.08     , "Pt ", 4100.0, 2045   , 21.4   , 9.10 ,
  "Platinum     ","[Xe]6s1_5d9 4f14 ",
1.79, 1.34,  79, 196.96654  , "Au ", 3130.0, 1337.58, 19.3   , 10.2 ,
  "Gold         ","[Xe]6s1_5d10_4f14 ",
1.76, 1.49,  80, 200.59     , "Hg ", 630.0 , 234.28 , 13.53  , 14.82,
  "Mercury      ","[Xe]6s2_5d10_4f14 ",
2.08, 1.48,  81, 204.3833   , "Tl ", 1746  , 577    , 11.85  , 17.2 ,
  "Thallium     ","[Xe]6s2_5d10_4f14_6p1 ",
1.81, 1.47,  82, 207.2      , "Pb ", 2023  , 600.6  , 11.4   , 18.17,
  "Lead         ","[Xe]6s2_5d10_4f14_6p2 ",
1.63, 1.46,  83, 208.98037  , "Bi ", 1837  , 544.52 , 9.8    , 21.3 ,
  "Bismuth      ","[Xe]6s2_5d10_4f14_6p3 ",
1.53, 1.46,  84, 209        , "Po ", 1235  , 527    , 9.4    , 22.23,
  "Polonium     ","[Xe]6s2_5d10_4f14_6p4 ",
1.43, 1.45,  85, 210.0      , "At ", 610.0 , 575    , 0.0    , 0.0  ,
  "Astatine     ","[Xe]6s2_5d10_4f14_6p5 ",
1.34, 1.43,  86, 222        , "Rn ", 211   , 202    , 9.91   , 50.5 ,
  "Radon        ","[Xe]6s2_5d10_4f14_6p6 ",
3.50, 2.50,  87, 223        , "Fr ", 950.0 , 300.0  , 0.0    , 0.0  ,
  "Francium     ","[Rn]7s1 ",
3.00, 2.40,  88, 226.025    , "Ra ", 1809  , 973    , 5      , 45.20,
  "Radium       ","[Rn]7s2 ",
3.20, 2.20,  89, 227.028    , "Ac ", 3473  , 1323   , 10.07  , 22.54,
  "Actinium     ","[Rn]7s2_6d1 ",
2.70, 1.65,  58, 140.115    , "Ce ", 3699  , 1071   , 6.78   , 20.67,
  "Cerium       ","[Xe]6s2_4f2 ",
2.67, 1.65,  59, 140.90765  , "Pr ", 3785  , 1204   , 6.77   , 20.8 ,
  "Praseodymium ","[Xe]6s2_4f3 ",
2.64, 1.64,  60, 144.24     , "Nd ", 3341  , 1289   , 7.00   , 20.6 ,
  "Neodymium    ","[Xe]6s2_4f4 ",
2.62, 1.63,  61, 145        , "Pm ", 3785  , 1204   , 6.475  , 22.39,
  "Promethium   ","[Xe]6s2_4f5 ",
2.59, 1.62,  62, 150.36     , "Sm ", 2064  , 1345   , 7.54   , 19.95,
  "Samarium     ","[Xe]6s2_4f6 ",
2.56, 1.85,  63, 151.965    , "Eu ", 1870.0, 1090.0 , 5.26   , 28.9 ,
  "Europium     ","[Xe]6s2_4f7 ",
2.54, 1.61,  64, 157.25     , "Gd ", 3539  , 1585   , 7.89   , 19.9 ,
  "Gadolinium   ","[Xe]6s2_5d1_4f7 ",
2.51, 1.59,  65, 158.92534  , "Tb ", 3496  , 1630.0 , 8.27   , 19.2 ,
  "Terbium      ","[Xe]6s2_4f9 ",
2.49, 1.59,  66, 162.50     , "Dy ", 2835  , 1682   , 8.54   , 19.0 ,
  "Dysprosium   ","[Xe]6s2_4f10 ",
2.47, 1.58,  67, 164.93032  , "Ho ", 2968  , 1743   , 8.80   , 18.7 ,
  "Holmium      ","[Xe]6s2_4f11 ",
2.45, 1.57,  68, 167.26     , "Er ", 3136  , 1795   , 9.05   , 18.4 ,
  "Erbium       ","[Xe]6s2_4f12 ",
2.42, 1.56,  69, 168.93421  , "Tm ", 2220.0, 1818   , 9.33   , 18.1 ,
  "Thulium      ","[Xe]6s2_4f13 ",
2.40, 1.74,  70, 173.04     , "Yb ", 1467  , 1097   , 6.98   , 24.79,
  "Ytterbium    ","[Xe]6s2_4f14 ",
2.25, 1.56,  71, 174.967    , "Lu ", 3668  , 1936   , 9.84   , 17.78,
  "Lutetium     ","[Xe]6s2_5d1_4f14 ",
3.16, 1.65,  90, 232.0381   , "Th ", 5061  , 2028   , 11.7   , 19.9 ,
  "Thorium      ","[Rn]7s2_6d2 ",
3.14, 0.0 ,  91, 231.03588  , "Pa ", 0.0   , 0.0    , 15.4   , 15.0 ,
  "Protactinium ","[Rn]7s2_6d1_5f2 ",
3.11, 1.42,  92, 238.0289   , "U  ", 4407  , 1405   , 18.90  , 12.59,
  "Uranium      ","[Rn]7s2_6d1_5f3 ",
3.08, 0.0 ,  93, 237.048    , "Np ", 0.0   , 910.0  , 20.4   , 11.62,
  "Neptunium    ","[Rn]7s2_6d1_5f4 ",
3.05, 0.0 ,  94, 244        , "Pu ", 3503  , 913    , 19.8   , 12.32,
  "Plutonium    ","[Rn]7s2_5f6 ",
3.02, 0.0 ,  95, 243        , "Am ", 2880.0, 1268   , 13.6   , 17.86,
  "Americium    ","[Rn]7s2_5f7 ",
2.99, 0.0 ,  96, 247        , "Cm ", 0.0   , 1340.0 , 13.511 , 18.28,
  "Curium       ","[Rn]7s2_6d1_5f7 ",
2.97, 0.0 ,  97, 247        , "Bk ", 0.0   , 0.0    , 0.0    , 0.0  ,
  "Berkelium    ","[Rn]7s2_6d1_5f8 ",
2.95, 0.0 ,  98, 251        , "Cf ", 0.0   , 900.0  , 0.0    , 0.0  ,
  "Californium  ","[Rn]7s2_5f10 ",
2.92, 0.0 ,  99, 252        , "Es ", 0.0   , 0.0    , 0.0    , 0.0  ,
  "Einsteinium  ","[Rn]7s2_5f11 ",
2.90, 0.0 , 100, 257        , "Fm ", 0.0   , 0.0    , 0.0    , 0.0  ,
  "Fermium      ","[Rn]7s2_5f12 ",
2.87, 0.0 , 101, 258        , "Md ", 0.0   , 0.0    , 0.0    , 0.0  ,
  "Mendelevium  ","[Rn]7s2_5f13 ",
2.85, 0.0 , 102, 259        , "No ", 0.0   , 0.0    , 0.0    , 0.0  ,
  "Nobelium     ","[Rn]7s2_5f14 ",
2.82, 0.0 , 103, 260.0      , "Lr ", 0.0   , 0.0    , 0.0    , 0.0  ,
  "Lawrencium   ","[Rn]7s2_6d1_5f14 "
};

#else

extern Widget toplevel, MainW;
extern Colormap default_cmap;
extern unsigned long red, white, slate_grey;
extern struct element_stats p_table[];
extern int done;
extern XFontStruct *BigFont;
extern GC BigGC;

#endif
