$! set ver
$
$ save_verify='f$verify(0)
$!
$! define machine type
$ axp = f$getsyi("ARCH_NAME") .eqs. "Alpha"
$ ia64 = f$getsyi("ARCH_NAME") .eqs. "IA64"
$ x86 = f$getsyi("ARCH_NAME") .eqs. "x86_64"
$!
$!      VMS compile and link for xabacus
$!
$! USAGE:
$! @make [debug clobber clean]
$!      debug : compile with debugger switch
$!      clean : clean all except executable
$!      clobber : clean all
$!
$! If you have
$!              XPM library
$!              XVMSUTILS library (VMS6.2 or lower)
$! insert the correct directory instead of X11:
$ xvmsutilsf="X11:XVMSUTILS.OLB"
$ xpmf="SYS$LIBRARY:LIBXPM.OLB"
$ xaw3df="SYS$SHARE:LIBXAW3D.EXE"
$ mmovf="SYS$LIBRARY:MMOV.OLB"
$ mmovf2="SYS$SHARE:MMOV.EXE"
$!
$! Default for some commands
$ xt_link=="link"
$ xt_cc=="cc/name=(as_is,short)/float=ieee"
$ if x86
$ then
$   xt_cxx=="cxx/name=(as_is,short)/point=32/warn=disable=(""c++11-extensions"")/assume=(nostdnew,noglobal_array_new"
$ else
$   xt_cxx=="cxx/name=(as_is,short)/float=ieee/assume=(nostdnew,noglobal_array_new"
$ endif
$!
$! Assume C.
$ deccxx=0
$! Assume C++ (but may not link on VMS6.2 or lower)
$! deccxx=1
$! test on C++.
$! deccxx=f$search("SYS$SYSTEM:CXX$COMPILER.EXE") .nes. ""
$!
$! Already assumes DEC C on Alpha.
$! Assume VAX C on VAX.
$! decc=0
$! Assume DEC C on VAX.
$! decc=1
$! test on DEC C.
$ decc=f$search("SYS$SYSTEM:DECC$COMPILER.EXE") .nes. ""
$!
$! if sound<>0 sound capability is included (only available on Alpha)
$! from vms_amd.c and vms_amd.h
$ sound=1
$! sound=0
$!
$! NOTHING SHOULD BE MODIFIED BELOW
$!
$ if p1 .eqs. "CLEAN" then goto Clean
$ if p1 .eqs. "CLOBBER" then goto Clobber
$!
$ defs=="HAVE_UNISTD_H"
$ defs=="''defs',HAVE_MOTIF"
$! defs=="''defs',HAVE_ATHENA"
$ xpm=f$search("''xpmf'") .nes. ""
$ xaw3d=f$search("''xaw3df'") .nes. ""
$ mmov=f$search("''mmovf'") .nes. ""
$ mmov2=f$search("''mmovf2'") .nes. ""
$ iscxx=f$search("SYS$SYSTEM:CXX$COMPILER.EXE") .nes. ""
$! Disable for now CXX on x86_64 due to bugs in the compiler
$ if x86 then iscxx = 0
$ sys_ver=f$edit(f$getsyi("version"),"compress")
$ if f$extract(0,1,sys_ver) .nes. "V"
$ then
$   type sys$input
This script will assume that the operating system version is at least V7.0.
$!
$   sys_ver="V7.0"
$ endif
$ sys_maj=0+f$extract(1,1,sys_ver)
$ if sys_maj .lt. 7
$ then
$   xvmsutils=f$search("''xvmsutilsf'") .nes. ""
$ endif
$!
$! Create .opt file
$ close/nolog optf
$ open/write optf xabacus.opt
$!
$ if iscxx then defs=="''defs',HAVE_CXX"
$ if xaw3d
$ then
$   defs=="''defs',HAVE_LIB_XAW3D"
$   define/nolog/job XAW3D SYS$COMMON:[SYSLIB.XAW3D]
$ endif
$ if xpm then defs=="''defs',HAVE_XPM"
$ if mmov .and. sound
$ then
$   defs=="''defs',HAS_MMOV"
$   if f$search("MMOV.DIR") .eqs. ""
$   then
$     create/dir [.mmov]
$     set def [.mmov]
$     copy SYS$COMMON:[SYSHLP.EXAMPLES.MMOV.COMMON]*.* []
$! spawn included to avoid unwanted redefinition of logicals
$     spawn @build_common
$     copy SYS$COMMON:[SYSHLP.EXAMPLES.MMOV.VIDEO]readavi.c []
$     spawn @[-]mmov
$     set def [-]
$   endif
$ endif
$ if axp .and. sound then defs=="''defs',USE_VMSPLAY"
$ if sys_maj .lt. 7
$ then
$   if xvmsutils then defs=="''defs',USE_XVMSUTILS"
$ endif
$ defs=="''defs',LEE_ABACUS"
$ defs=="''defs',USE_SPIN"
$ defs=="''defs',USE_BASE_SPIN"
$! Spinner and ability to setToggle will not work as VMS uses old Motif
$! defs=="''defs',""""DATAPATH=[]"""""
$! defs=="''defs',""""BUMPSOUND=[]bump.au"""",""""MOVESOUND=[]move.au"""",""""DRIPSOUND=[]drip.au"""""
$ if sys_maj .ge. 7
$ then
$   defs=="''defs',HAVE_USLEEP"
$! The next must be the last one.
$   defs=="''defs',""""SRAND=srand48"""",""""LRAND=lrand48"""",MAXRAND=2147483648.0"
$ endif
$!
$! Establish the Compiling Environment
$!
$! Set compiler command
$! Put in /include=[] for local include file like a pwd.h ...
$!  not normally required.
$!    xt_cxx=="cxx/name=(as_is,short)/float=ieee/assume=(nostdnew,noglobal_array_new)/include=([])/define=(''defs')"
$ if x86
$ then
$   xt_cxx=="cxx/name=(as_is,short)/point=32/warn=disable=(""c++11-extensions"")/assume=(nostdnew,noglobal_array_new)/include=([])/define=(''defs')"
$ else
$   xt_cxx=="cxx/name=(as_is,short)/float=ieee/assume=(nostdnew,noglobal_array_new)/include=([])/define=(''defs')"
$ endif
$ if deccxx
$ then
$   if x86
$   then
$     xt_cc=="cxx/name=(as_is,short)/point=32/warn=disable=(""c++11-extensions"")/assume=(nostdnew,noglobal_array_new)/include=([])/define=(''defs')"
$   else
$     xt_cc=="cxx/name=(as_is,short)/float=ieee/assume=(nostdnew,noglobal_array_new)/include=([])/define=(''defs')"
$   endif
$ else
$   if axp .or. ia64 .or. x86
$   then
$     xt_cc=="cc/name=(as_is,short)/float=ieee/include=([])/define=(''defs')"
$   else
$     if decc
$     then
$!       xt_cc=="cc/decc/standard=vaxc/include=([])/define=(''defs')"
$       xt_cc=="cc/decc/include=([])/define=(''defs')"
$     else ! VAX C
$       xt_cc=="cc/include=([])/define=(''defs')"
$     endif
$   endif
$ endif
$ if p1 .eqs. "DEBUG" .or. p2 .eqs. "DEBUG" .or. p3 .eqs. "DEBUG"
$ then
$   if deccxx
$   then
$     if x86
$     then
$       xt_cc=="cxx/name=(as_is,short)/point=32/warn=disable=(""c++11-extensions"")/assume=(nostdnew,noglobal_array_new)/deb/noopt/include=([])/define=(''defs')/list"
$     else
$       xt_cc=="cxx/name=(as_is,short)/float=ieee/assume=(nostdnew,noglobal_array_new)/deb/noopt/include=([])/define=(''defs')/list"
$     endif
$   else
$     if axp .or. ia64 .or. x86
$     then
$!       xt_cc=="cc/name=(as_is,short)/float=ieee/deb/noopt/include=([])/define=(''defs')/list"
$       xt_cc=="cc/name=(as_is,short)/point=32/deb/noopt/include=([])/define=(''defs')/list"
$     else
$       if decc
$       then
$!         xt_cc=="cc/deb/noopt/decc/standard=vaxc/include=([])/define=(''defs')/list"
$         xt_cc=="cc/deb/noopt/decc/include=([])/define=(''defs')/list"
$       else ! VAX C
$         xt_cc=="cc/deb/noopt/include=([])/define=(''defs')/list"
$       endif
$     endif
$   endif
$   if iscxx
$   then
$     if x86
$     then
$       xt_link=="link/deb"
$     else
$       xt_link=="cxxlink/deb"
$     endif
$   else
$     xt_link=="link/deb"
$   endif
$ else
$   if x86
$   then
$     if iscxx then xt_link=="link/trace"
$   else
$     if iscxx then xt_link=="cxxlink/trace"
$   endif
$ endif
$!
$ if axp .or. ia64 .or. x86 .or. .not. decc
$ then
$   define/nolog sys sys$library
$ endif
$!
$ write sys$output "Compiling xabacus with ''defs'"
$ call make Abacus.obj  "xt_cc Abacus.c"  Abacus.c AbacusP.h Abacus.h xwin.h file.h timer.h
$ call make AbacusU.obj  "xt_cc AbacusU.c"  AbacusU.c AbacusP.h Abacus.h
$ call make AbacusC.obj  "xt_cc AbacusC.c"  AbacusC.c AbacusP.h Abacus.h
$ call make AbacusD.obj  "xt_cc AbacusD.c"  AbacusD.c AbacusP.h Abacus.h file.h
$ call make AbacusM.obj  "xt_cc AbacusM.c"  AbacusM.c AbacusP.h Abacus.h
$ call make AbacusT.obj  "xt_cc AbacusT.c"  AbacusT.c AbacusP.h Abacus.h
$ call make AbacusF.obj  "xt_cc AbacusF.c"  AbacusF.c AbacusP.h Abacus.h
$ call make AbacusE.obj  "xt_cc AbacusE.c"  AbacusE.c AbacusP.h Abacus.h
$ call make xwin.obj  "xt_cc xwin.c"  xwin.c xwin.h
$ call make xgui.obj  "xt_cc xgui.c"  xgui.c xgui.h
$ call make file.obj  "xt_cc file.c"  file.c file.h
$ call make timer.obj  "xt_cc timer.c"  timer.c timer.h
$! if sound
$! then
$!   call make sound.obj  "xt_cc sound.c"  sound.c sound.h file.h vms_amd.h
$!   if axp
$!   then
$!     call make vms_amd.obj  "xt_cc vms_amd.c"  vms_amd.c vms_amd.h
$!   endif
$! endif
$ call make xabacus.obj  "xt_cc xabacus.c"  xabacus.c Abacus.h xwin.h xgui.h file.h version.h
$!
$! Get libraries
$ if xpm then write optf "''xpmf'/lib"
$ if xaw3d then write optf "''xaw3df'/share"
$ if sys_maj .lt. 7
$ then
$   if xvmsutils then write optf "''xvmsutilsf'/lib"
$ endif
$ if mmov
$ then
$   write optf "[.mmov]vms_mmov.obj"
$   write optf "[.mmov]readavi.obj"
$   write optf "[.mmov]commonlib.olb/lib"
$   if mmov2
$   then
$     write optf "sys$share:mmov.exe/share"
$   else
$     when:==on
$     when error then continue
$     open/write optf1 mmov_link.opt
$     write optf1 "sys$library:vaxcrtl/lib"
$     write optf1 "sys$share:cma$open_rtl.exe/share"
$     close optf1
$     lib/extract=* sys$library:mmov.olb/lib
$     link/exec=mmov.exe/share mmov/opt,mmov_vms.opt/opt,mmov_link/opt
$     write optf "mmov.exe/share"
$     copy mmov.exe sys$share:mmov.exe
$     write sys$output "If the copy failed you have to place the file mmov.exe"
$     write sys$output "in the directory sys$share manually before running program"
$     noon
$   endif
$ endif
$ if .not. ia64 .and. .not. x86 then write optf "sys$library:vaxcrtl/lib"
$ if axp .or. ia64 .or. x86 then write optf "sys$library:ucx$ipc_shr/share"
$ if axp .or. ia64 .or. x86 then write optf "sys$share:decw$xextlibshr/share"
$ if axp .or. ia64 .or. x86 then write optf "sys$share:decw$xtlibshrr5/share"
$ if .not. ( axp .or. ia64 .or. x86 ) then write optf "sys$library:ucx$ipc/lib"
$! write optf "sys$share:decw$dxmlibshr/share"
$ write optf "sys$share:decw$xmlibshr12/share"
$ write optf "sys$share:decw$xlibshr/share"
$ close optf
$!
$! LINK
$ write sys$output "Linking xabacus"
$ xt_link/map/exec=[] xabacus/opt
$!
$ if mmov
$ then
$   write sys$output "NOTE:"
$   write sys$output "Sound files are played only when the user has the SYSNAM"
$   write sys$output "as an authorized privilege"
$ endif
$ set noverify
$ exit
$!
$Clobber:      ! Delete executables, Purge directory and clean up object files
$!                and listings
$ delete/noconfirm/log xabacus.exe;*
$!
$Clean:        ! Purge directory, clean up object files and listings
$ close/nolog optf
$ purge
$ delete/noconfirm/log *.lis;*
$ delete/noconfirm/log *.obj;*
$ delete/noconfirm/log *.opt;*
$ delete/noconfirm/log *.map;*
$!
$ exit
$!
! SUBROUTINE TO CHECK DEPENDENCIES
$ make: subroutine
$   v='f$verify(0)
$!  p1      What we are trying to make
$!  p2      Command to make it
$!  p3 - p8  What it depends on
$
$   if (f$extract(0,6,p2) .eqs. "xt_cc ") then write optf "''p1'"
$   if (f$extract(0,7,p2) .eqs. "xt_cxx ") then write optf "''p1'"
$
$   if f$search(p1) .eqs. "" then goto MakeIt
$   time=f$cvtime(f$file(p1,"RDT"))
$   arg=3
$Loop:
$   argument=p'arg
$   if argument .eqs. "" then goto Exit
$   el=0
$Loop2:
$   file=f$element(el," ",argument)
$   if file .eqs. " " then goto Endl
$   afile=""
$Loop3:
$   ofile=afile
$   file1 = f$element(1,",",file)
$   file = f$element(0,",",file)
$   if ( file1 .ne. "" )
$   then
$     afile=f$search(file1)
$     if afile .eqs. "" .or. afile .eqs. ofile then goto NextEl1
$     if f$cvtime(f$file(afile,"RDT")) .gts. time then goto MakeIt
$   endif
$NextEl1:
$   afile=f$search(file)
$   if afile .eqs. "" .or. afile .eqs. ofile then goto NextEl
$   if f$cvtime(f$file(afile,"RDT")) .gts. time then goto MakeIt
$   goto Loop3
$NextEL:
$   el=el+1
$   goto Loop2
$EndL:
$   arg=arg+1
$   if arg .le. 8 then goto Loop
$   goto Exit
$
$MakeIt:
$   set verify
$   'p2
$   vv='f$verify(0)
$Exit:
$   if v then set verify
$ endsubroutine
