NAME = abacus
WIDGET = Abacus
C=.c
O=.obj
E=.exe
P=x
R=$(P)
PROG = $(R)$(NAME)$(E)

## update opt for libs

# bare bones, no Motif, Xaw3d, Xpm, and Xmu
#CC_DEFS = /define=(HAVE_UNISTD,HAVE_USLEEP,"SRAND=srand48","LRAND=lrand48",MAXRAND=2147483648.0)/name=(as_is,short)/float=ieee

# No Motif or Xaw3d
#CC_DEFS = /define=(HAVE_UNISTD,HAVE_USLEEP,HAVE_XPM,USE_XMU,HAVE_EDITRES,"SRAND=srand48","LRAND=lrand48",MAXRAND=2147483648.0)/name=(as_is,short)/float=ieee

# default VMS
#CC_DEFS = /define=(HAVE_UNISTD,HAVE_USLEEP,HAVE_MOTIF,LEE_ABACUS,USE_SPIN,USE_BASE_SPIN,"SRAND=srand48","LRAND=lrand48",MAXRAND=2147483648.0)/name=(as_is,short)/float=ieee

# prefered if available, Motif with Xpm and Xmu
CC_DEFS = /define=(HAVE_UNISTD,HAVE_USLEEP,HAVE_MOTIF,HAVE_XPM,USE_XMU,HAVE_EDITRES,LEE_ABACUS,USE_SPIN,USE_BASE_SPIN,"SRAND=srand48","LRAND=lrand48",MAXRAND=2147483648.0)/name=(as_is,short)/float=ieee

# Xaw3d instead of Motif, with Xpm and Xmu
#CC_DEFS = /define=(HAVE_UNISTD,HAVE_USLEEP,HAVE_ATHENA,HAVE_LIB_XAW3D,HAVE_XPM,USE_XMU,HAVE_EDITRES,LEE_ABACUS,USE_SPIN,USE_BASE_SPIN,"SRAND=srand48","LRAND=lrand48",MAXRAND=2147483648.0)/name=(as_is,short)/float=ieee

# TODO try with HAVE_LIBXML2

# C++, update opt
CXX_DEFS = "-DHAVE_UNISTD" "-DHAVE_USLEEP" "-DHAVE_MOTIF" "-DHAVE_XPM" "USE_XMU" "HAVE_EDITRES" "-DLEE_ABACUS" "-DUSE_SPIN" "-DUSE_BASE_SPIN" "-DSRAND=srand48" "-DLRAND=lrand48" "-DMAXRAND"=2147483648.0 -names=as_is

CC_DEB =

OBJS = $(P)$(NAME)$(O),-
$(WIDGET)$(O),-
$(WIDGET)U$(O),-
$(WIDGET)C$(O),-
$(WIDGET)D$(O),-
$(WIDGET)M$(O),-
$(WIDGET)T$(O),-
$(WIDGET)F$(O),-
$(WIDGET)E$(O),-
xwin$(O),-
file$(O),-
timer$(O),-
rngs$(O),-
xgui$(O)

#sound$(O)

CFLAGS = $(C_DEB) $(CC_DEFS)

CXXFLAGS = $(CXX_DEFS)

$(C)$(O) :
	cc $(CFLAGS) $(MMS$TARGET_NAME)$(C)

#	clang $(CXXFLAGS) -o $(MMS$TARGET_NAME)$(O) $(MMS$TARGET_NAME)$(C)

.first :
	@ define/nolog/job XAW3D SYS$COMMON:[SYSLIB.XAW3D]

all : $(PROG)
	@ directory $(PROG)

$(P)$(NAME)$(O) : $(P)$(NAME)$(C) $(WIDGET).h xwin.h file.h xgui.h version.h
$(WIDGET)$(O) : $(WIDGET)$(C) $(WIDGET)P.h $(WIDGET).h xwin.h
$(WIDGET)U$(O) : $(WIDGET)U$(C) $(WIDGET)P.h $(WIDGET).h
$(WIDGET)C$(O) : $(WIDGET)C$(C) $(WIDGET)P.h $(WIDGET).h
$(WIDGET)D$(O) : $(WIDGET)D$(C) $(WIDGET)P.h $(WIDGET).h file.h
$(WIDGET)M$(O) : $(WIDGET)M$(C) $(WIDGET)P.h $(WIDGET).h
$(WIDGET)T$(O) : $(WIDGET)T$(C) $(WIDGET)P.h $(WIDGET).h
$(WIDGET)F$(O) : $(WIDGET)F$(C) $(WIDGET)P.h
$(WIDGET)E$(O) : $(WIDGET)E$(C) $(WIDGET)P.h
xwin$(O) : xwin$(C) xwin.h
file$(O) : file$(C) file.h
timer$(O) : timer$(C) timer.h
rngs$(O) : rngs$(C) rngs.h
sound$(O) : sound$(C) sound.h file.h
xgui$(O) : xgui$(C) xgui.h

$(R)$(NAME).opt :
	close/nolog optf
	open/write optf $(R)$(NAME).opt
	write optf "SYS$SHARE:DECW$XLIBSHR/SHARE"
	write optf "SYS$SHARE:DECW$XTLIBSHRR5/SHARE"
	write optf "SYS$SHARE:DECW$XEXTLIBSHR/SHARE"
#	write optf "SYS$SHARE:DECW$XMULIBSHR/SHARE"
	write optf "SYS$SHARE:LIBXMU.EXE/SHARE"
#	write optf "SYS$LIBRARY:LIBXMU.OLB/LIB"
#	write optf "SYS$LIBRARY:LIBXMU_CXX.OLB/LIB"
	write optf "SYS$SHARE:DECW$XMLIBSHR12/SHARE"
	write optf "SYS$SHARE:LIBXAW3D.EXE/SHARE"
	write optf "SYS$LIBRARY:LIBXPM.OLB/LIB"
#	write optf "SYS$LIBRARY:LIBXPM_CXX.OLB/LIB"
#	write optf "SYS$SHARE:LIBXML2.EXE/SHARE"
	close optf

$(PROG) : $(OBJS),$(R)$(NAME).opt
	link $(OBJS),$(R)$(NAME)/opt

#	link/deb $(OBJS),$(R)$(NAME)/opt

clean :
	close/nolog optf
	purge
	delete *.lis;*,*.obj;*,*.opt;*

clobber : clean
	delete *.exe;*
