/*
 * @(#)AbacusF.c
 *
 * Copyright 2017  David A. Bagley, bagleyd AT verizon.net
 *
 * Abacus examples
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Method to handle the fallback demo for Abacus */

#include "AbacusP.h"

const char *bookTextFallback[1][LINES] =
{
	{
		"  Abacus Demo by Luis Fernandes and David Bagley",
		READ_BOOK,
		NEXT_BOOK,
		QUIT,
	},
};

const char *chapterTextFallback[1][5][LINES] =
{
	{
		{
			"     1. Increment Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		}, {
			"     2. Decrement Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		}, {
			"     3. Addition Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		}, {
			"     4. Subtraction Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		}, {
			"     5. Multiplication Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		/*}, {
			"     6. Division Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		}, {
			"     7. Square Root Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,
		}, {
			"     8. Cube Root Chapter",
			READ_CHAPTER,
			NEXT_CHAPTER,
			QUIT,*/
		},
	},
};

unsigned int
getFallbackBooks(void) {
	return 1;
}

unsigned int
getFallbackEditions(void) {
	return 4;
}

unsigned int
getFallbackChapters(void) {
	return 5;
}

/* bad kludge, but next one worse */
unsigned int
getFallbackLessons(unsigned int chapter) {
	if (chapter == 0)
		return 2;
	else
		return 1;
}

unsigned int
getFallbackMoves(unsigned int edition, unsigned int chapter, unsigned int lesson) {
	if (edition == 0) { /* cn */
		if (chapter == 0)
			if (lesson == 0)
				return 41;
			else
				return 31;
		else if (chapter == 1)
			return 29;
		else if (chapter == 2)
			return 16;
		else if (chapter == 3)
			return 7;
		else if (chapter == 4)
			return 14;
	} else if (edition == 1) { /* jp */
		if (chapter == 0)
			if (lesson == 0)
				return 35;
			else
				return 28;
		else if (chapter == 1)
			return 29;
		else if (chapter == 2)
			return 13;
		else if (chapter == 3)
			return 7;
		else if (chapter == 4)
			return 14;
	} else if (edition == 2) { /* ko */
		if (chapter == 0)
			if (lesson == 0)
				return 39;
			else
				return 30;
		else if (chapter == 1)
			return 29;
		else if (chapter == 2)
			return 13;
		else if (chapter == 3)
			return 7;
		else if (chapter == 4)
			return 14;
	} else if (edition == 3) { /* ru */
		if (chapter == 0)
			if (lesson == 0)
				return 31;
			else
				return 20;
		else if (chapter == 1)
			return 24;
		else if (chapter == 2)
			return 12;
		else if (chapter == 3)
			return 7;
		else if (chapter == 4)
			return 11;
	}
	return 41;
}


const char *lessonTextFallback[1][4][5][2][41][LINES + 1] =
{{{
	/* chineseLesson, *//* Medieval also */
{{{
			"0 0 0 0 4",
			"Lesson1.1: Counting from 1 to 20 for Chinese Abacus or Medieval Counter",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"4",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"5",
			"(We're not done yet...)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"It gets a bit tricky here. A carry to the upper-deck, and",
			"a reset of the lower deck will complete counting 5.",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"5 (pending operation)",
			"Carry-over to Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -5 4",
			"Lesson1.1: Counting",
			"5",
			"...and Reset Lower-deck...",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"This is 5. In reality, the 5th bead is never moved, the",
			"carry-reset operation is performed in one motion.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"7",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"9",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"10",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"10 (pending operation)",
			"Carry-over to Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -5 4",
			"Lesson1.1: Counting",
			"10 (pending operation)",
			"...Reset Lower-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"10",
			"Carry-over to Previous Column",
			"Press Space-bar",
		}, {
			"0 1 0 -2 4",
			"Lesson1.1: Counting",
			"10",
			"Reset Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"Counting 10 was similar to counting 5, with the",
			"addition of the extra carry to the Previous Column",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"13",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"14",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -4 4",
			"Lesson1.1: Counting",
			"15 (pending operation)",
			"Reset Bottom-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"15",
			"...Carry-over to Upper-deck.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"18",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"19",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"20",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"Carry-over to the Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -5 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Reset Lower-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Carry-over To The Previous Column.",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -2 4",
			"Lesson1.1: Counting",
			"20",
			"...And Reset Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -2 4",
			"Lesson1.1: End",
			"And now, some conclusions...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"Each of the 2 beads on the upper-deck has a value of 5.",
			"Each of the 5 beads on the lower-deck has a value of 1.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 5 beads on the lower deck requires a carry of",
			"1 bead to the upper-deck.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 2 beads on the upper deck requires a carry of",
			"1 bead on the lower-deck of the previous column.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Every column to the left of one's column is an",
			"order of magnitude greater.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Columns to the right of the one's column are used",
			"for calculations involving decimals.",
			"Press Space-bar"
		}}, {{
			"0 0 0 0 4",
			"Lesson 1.2: Counting by 2's to 30 for Chinese Abacus or Medieval Counter",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"2",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"4",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"6",
			"(We're not done yet...) ",
			"Press Space-bar",
		}, {
			"0 0 0 -5 4",
			"Lesson 1.2 Counting by 2's",
			"6",
			"must take away five and...",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"add a bead of value 5 from top deck...",
			"6",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"then add one.",
			"6",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"8",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"Correct but not done yet...",
			"Press Space-bar",
		}, {
			"0 0 0 -5 4",
			"Lesson 1.2 Counting by 2's",
			"10  ... Hold on...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"Correct but still not done yet...",
			"Press Space-bar",
		}, {
			"0 1 0 -2 4",
			"Lesson 1.2 Counting by 2's",
			"... Hold on again...",
			"10",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"OK now we can move on",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"12",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"14",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"16  Taking a short cut",
			"Add 2 by taking away 4 and adding 6",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"Adding 5 ",
			"16  Continued...",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"Finish adding 6 by adding 1",
			"16",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"18",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"20  Taking a short cut",
			"Add 2 by taking away 8 and adding 10",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"20",
			"Finish taking away 8",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"Now add 10 for",
			"20",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"22",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"24",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"26  Remember short cut...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"26  Still calculating...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"26",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"28",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"30  Short cut again...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"30  ...  not done yet",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"30  Done!",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 2.1: Counting down from 19 to 0 for Chinese Abacus or Medieval Counter",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 2.1: Counting Down",
			"One bead in 10ths column",
			"10 ",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 2.1: Counting Down",
			"Plus one bead in 5ths column",
			"15",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Plus 4 beads in ones column",
			"19  ok now we are ready to start",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"Move one bead down to get",
			"18",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"15",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 2.1: Counting Down",
			"14   Subtract 5 from top deck by moving",
			"it up (but we are not done yet...)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"add 4 to get...",
			"14",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"13",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"10",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 2.1: Counting Down",
			"9  Subtract the tens place out",
			"but we are not done yet...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 2.1: Counting Down",
			"9  Adding 5 + 4 back in so first",
			"the 5...  (pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Adding the 4 in to get",
			"9",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"7",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"5",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 2.1: Counting Down",
			"4 but wait now...",
			"(pending opertation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Add four to get",
			"4",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"0",
			"Done.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"When subtracting 1 from 10",
			"you take away 10 and add 9.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"When subtracting 1 from 5",
			"you take away 5 and add 4.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 3.1: Addition",
			"This Lesson demonstrates 2 addition problems:",
			"6+5 & 23+9",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 1 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"We Represent 6 by Adding 5...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"...and 1.",
			"(This is 6)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"Adding the 5...",
			"(Requires a Carry)...",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (6+5)",
			"...So We Carry to the Previous Column...",
			"(The ten's Column)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -2 4",
			"Lesson 3.1: Addition (6+5)",
			"...We Reset The Upper-deck and Obtain The Answer.",
			"10 in the Previous Column + 1 in the Current= 11.",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 3.1: Addition",
			"That was a Straight-forward Example...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition",
			"The following one is a bit more complicated.",
			"So, pay attention...",
			"Press Space-bar to Begin",
		}, {
			"0 0 1 2 4",
			"Lesson 3.1: Addition (23+9)",
			"20... (begin to represent 23)",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 3 4",
			"Lesson 3.1: Addition (23+9)",
			"...+3, represents 23.",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 2 4",
			"Lesson 3.1: Addition (23+9)",
			"Represent 9 as +10 -1.    So, 2 Beads on upper-deck= 10...",
			"(pending carry to the ten's column)",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (23+9)",
			"...carry to ten's column...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 -2 4",
			"Lesson 3.1: Addition (23+9)",
			"Reset Upper-deck of Current-column...",
			"(Pending the `-1' of +10-1= +9)",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition (23+9)",
			"... -1 (Current-column) completes +9",
			"Resulting in the answer: 32",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To gain proficiency in using the abacus, practice !",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction",
			"This Lesson demonstrates subtracting 7 from 11",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"First Represent 11 as 10...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...and 1.",
			"(This is 11)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction (11-7)",
			"We Represent -7 as -10+3, so...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"-10 ...",
			"(pending operation +3)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 3 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...+3 Completes The Operation",
			"The Answer is +4.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 5.1: Multiplication",
			"This Lesson demonstrates multiplying 23 * 42",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"1 0 1 2 4",
			"Lesson 5.1: Multiplcation (23*42)",
			"First Represent 23 as 20...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"1 0 0 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 3.",
			"(This is 23)",
			"Press Space-bar to Continue",
		}, {
			"2 0 1 4 4",
			"Lesson 5.1: Multiplication (23*42)",
			"We Represent 4 as 40, so...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"2 0 0 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 2.",
			"(This is 42)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*4=12",
			"Add 10 part of 12 as 100",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add 2 part of 12 as 20",
			"(For 12)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*2=6  so add a 5+1",
			"5....",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"... 1 part",
			"(For 6)",
			"Press Space-bar to Continue",
		}, {
			"0 1 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*4=8",
			"Add 800 as 500+300, so add 500 (for 626)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"and add 300",
			"(For 926)",
			"Press Space-bar to Continue",
		}, {
			"0 1 1 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*2=4",
			"So... add 40 (as 50 - 10), so first 50 part",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add -10 part for ...",
			"Result 966",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Using the auxiliary abaci to keep the multiplicands",
			"and using the primary to add up from the results.",
			"Press Space-bar"
}}},
}, {
	/* japaneseLesson, *//* Roman also */
{{{
			"0 0 0 0 4",
			"Lesson1.1: Counting from 1 to 20 for Japanese or Roman Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"4",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"It gets a bit tricky here. A carry to the upper-deck, and",
			"a reset of the lower deck will complete counting 5.",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"5 (pending operation)",
			"Carry-over to Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -4 4",
			"Lesson1.1: Counting",
			"5",
			"...and Reset Lower-deck... this is 5.",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"7",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"9",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"10 (pending operation)",
			"Carry-over to Previous Column...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -4 4",
			"Lesson1.1: Counting",
			"10 (pending operation)",
			"...Reset Lower-deck...",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson1.1: Counting",
			"10",
			"Reset Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"Counting 10 was similar to counting 5, with the",
			"addition of the extra carry to the Previous Column",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"13",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"14",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -4 4",
			"Lesson1.1: Counting",
			"15 (pending operation)",
			"Reset Bottom-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"15",
			"...Carry-over to Upper-deck.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"18",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"19",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Carry-over To The Previous Column.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -4 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Reset Lower-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson1.1: Counting",
			"20",
			"...And Reset Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -2 4",
			"Lesson1.1: End",
			"And now, some conclusions...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"Each bead on the upper-deck has a value of 5.",
			"Each of the 4 beads on the lower-deck has a value of 1.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 5 beads on the lower deck requires a carry of",
			"1 bead to the upper-deck.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 2 beads on the upper deck requires a carry of",
			"1 bead on the lower-deck of the previous column.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Every column to the left of one's column is an",
			"order of magnitude greater.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Columns to the right of the one's column are used",
			"for calculations involving decimals.",
			"Press Space-bar"
		}}, {{
			"0 0 0 0 4",
			"Lesson 1.2: Counting by 2's to 30 for Japanese or Roman Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"2",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"4",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"6",
			"must take away four and...",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"add a bead of value 5 from top deck...",
			"6",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"then add one.",
			"6",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"8",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"10  ... Hold on ...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"Still working on it  ",
			"10",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"OK now we can move on",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"12",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"14",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"16  Taking a short cut",
			"Add 2 by taking away 4 and adding 6",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"Adding 5 ",
			"16  Continued...",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"Finish adding 6 by adding 1",
			"16",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"18",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"20  Taking a short cut",
			"Add 2 by taking away 8 and adding 10",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"20",
			"Finish taking away 8",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"Now add 10 for",
			"20",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"22",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"24",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"26  Remember short cut...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"26  Still calculating...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"26",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"28",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"30  Short cut again...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"30  ...  not done yet",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"30  Done!",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 2.1: Count down from 19..0 for Japanese or Roman Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 2.1: Counting Down",
			"One bead in 10ths column",
			"10 ",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 2.1: Counting Down",
			"Plus one bead in 5ths column",
			"15",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Plus 4 beads in ones column",
			"19  ok now we are ready to start",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"Move one bead down to get",
			"18",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"15",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 2.1: Counting Down",
			"14   Subtract 5 from top deck by moving",
			"it up (but we are not done yet...)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"add 4 to get...",
			"14",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"13",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"10",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 2.1: Counting Down",
			"9  Subtract the tens place out",
			"but we are not done yet...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 2.1: Counting Down",
			"9  Adding 5 + 4 back in so first",
			"the 5...  (pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Adding the 4 in to get",
			"9",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"7",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"5",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 2.1: Counting Down",
			"4 but wait now...",
			"(pending opertation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Add four to get",
			"4",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"0",
			"Done.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"When subtracting 1 from 10",
			"you take away 10 and add 9.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"When subtracting 1 from 5",
			"you take away 5 and add 4.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 3.1: Addition",
			"This Lesson demonstrates 2 addition problems:",
			"6+5 & 23+9",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 1 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"We Represent 6 by Adding 5...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"...and 1.",
			"(This is 6)",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (6+5)",
			"Adding the 5 so We Carry to the Previous Column...",
			"(The ten's Column)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 3.1: Addition (6+5)",
			"...We Reset The Upper-deck and Obtain The Answer.",
			"10 in the Previous Column + 1 in the Current= 11.",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 3.1: Addition",
			"That was a Straight-forward Example...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition",
			"The following one is a bit more complicated.",
			"So, pay attention...",
			"Press Space-bar to Begin",
		}, {
			"0 0 1 2 4",
			"Lesson 3.1: Addition (23+9)",
			"20... (begin to represent 23)",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 3 4",
			"Lesson 3.1: Addition (23+9)",
			"...+3, represents 23.",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (23+9)",
			"Represent 9 as +10 -1.",
			"So, 1 Beads on previous  column= 10...",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition (23+9)",
			"... -1 (Current-column) completes +9",
			"Resulting in the answer: 32",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To gain proficiency in using the abacus, practice !",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction",
			"This Lesson demonstrates subtracting 7 from 11",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"First Represent 11 as 10...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...and 1.",
			"(This is 11)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction (11-7)",
			"We Represent -7 as -10+3, so...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"-10 ...",
			"(pending operation +3)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 3 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...+3 Completes The Operation",
			"The Answer is +4.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 5.1: Multiplication",
			"This Lesson demonstrates multiplying 23 * 42",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"1 0 1 2 4",
			"Lesson 5.1: Multiplcation (23*42)",
			"First Represent 23 as 20...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"1 0 0 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 3.",
			"(This is 23)",
			"Press Space-bar to Continue",
		}, {
			"2 0 1 4 4",
			"Lesson 5.1: Multiplication (23*42)",
			"We Represent 4 as 40, so...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"2 0 0 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 2.",
			"(This is 42)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*4=12",
			"Add 10 part of 12 as 100",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add 2 part of 12 as 20",
			"(For 12)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*2=6  so add a 5+1",
			"5....",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"... 1 part",
			"(For 6)",
			"Press Space-bar to Continue",
		}, {
			"0 1 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*4=8",
			"Add 800 as 500+300, so add 500 (for 626)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"and add 300",
			"(For 926)",
			"Press Space-bar to Continue",
		}, {
			"0 1 1 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*2=4",
			"So... add 40 (as 50 - 10), so first 50 part",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add -10 part for ...",
			"Result 966",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Using the auxiliary abaci to keep the multiplicands",
			"and using the primary to add up from the results.",
			"Press Space-bar"
}}},
}, {
	/* koreanLesson, */
{{{
			"0 0 0 0 4",
			"Lesson1.1: Counting from 1 to 20 for Korean Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"4",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"5",
			"(We're not done yet...)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"It gets a bit tricky here. A carry to the upper-deck, and",
			"a reset of the lower deck will complete counting 5.",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"5 (pending operation)",
			"Carry-over to Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -5 4",
			"Lesson1.1: Counting",
			"5",
			"...and Reset Lower-deck...",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"This is 5. In reality, the 5th bead is never moved, the",
			"carry-reset operation is performed in one motion.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"7",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"9",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"10",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"10",
			"Carry-over to Previous Column",
			"Press Space-bar",
		}, {
			"0 0 0 -5 4",
			"Lesson1.1: Counting",
			"10 (pending operation)",
			"...Reset Lower-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson1.1: Counting",
			"10",
			"Reset Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"Counting 10 was similar to counting 5, with the",
			"addition of the extra carry to the Previous Column",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"13",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"14",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -4 4",
			"Lesson1.1: Counting",
			"15 (pending operation)",
			"Reset Bottom-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson1.1: Counting",
			"15",
			"...Carry-over to Upper-deck.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"18",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"19",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"20",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"20 (pending operation)",
			"...Carry-over To The Previous Column.",
			"Carry-over to the Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -5 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Reset Lower-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson1.1: Counting",
			"20",
			"...And Reset Upper-deck...",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -2 4",
			"Lesson1.1: End",
			"And now, some conclusions...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"Each bead on the upper-deck has a value of 5.",
			"Each of the 5 beads on the lower-deck has a value of 1.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 5 beads on the lower deck requires a carry of",
			"1 bead to the upper-deck.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 2 beads on the upper deck requires a carry of",
			"1 bead on the lower-deck of the previous column.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Every column to the left of one's column is an",
			"order of magnitude greater.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Columns to the right of the one's column are used",
			"for calculations involving decimals.",
			"Press Space-bar"
		}}, {{
			"0 0 0 0 4",
			"Lesson 1.2: Counting by 2's to 30 for Korean Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"2",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"4",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"6",
			"(We're not done yet...) ",
			"Press Space-bar",
		}, {
			"0 0 0 -5 4",
			"Lesson 1.2 Counting by 2's",
			"6",
			"must take away five and...",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"add a bead of value 5 from top deck...",
			"6",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"then add one.",
			"6",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"8",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"Correct but not done yet...",
			"Press Space-bar",
		}, {
			"0 0 0 -5 4",
			"Lesson 1.2 Counting by 2's",
			"10  ... Hold on ...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"Still working on it  ",
			"10",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"OK now we can move on",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"12",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"14",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"16  Taking a short cut",
			"Add 2 by taking away 4 and adding 6",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"Adding 5 ",
			"16  Continued...",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"Finish adding 6 by adding 1",
			"16",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"18",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"20  Taking a short cut",
			"Add 2 by taking away 8 and adding 10",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"20",
			"Finish taking away 8",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"Now add 10 for",
			"20",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"22",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"24",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -4 4",
			"Lesson 1.2 Counting by 2's",
			"26  Remember short cut...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"26  Still calculating...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 1 4",
			"Lesson 1.2 Counting by 2's",
			"26",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"28",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -3 4",
			"Lesson 1.2 Counting by 2's",
			"30  Short cut again...",
			"",
			"Press Space-bar",
		}, {
			"0 1 0 -1 4",
			"Lesson 1.2 Counting by 2's",
			"30  ...  not done yet",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"30  Done!",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 2.1: Counting down from 19 to 0 for Korean Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 2.1: Counting Down",
			"One bead in 10ths column",
			"10 ",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 2.1: Counting Down",
			"Plus one bead in 5ths column",
			"15",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Plus 4 beads in ones column",
			"19  ok now we are ready to start",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"Move one bead down to get",
			"18",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"15",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 2.1: Counting Down",
			"14   Subtract 5 from top deck by moving",
			"it up (but we are not done yet...)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"add 4 to get...",
			"14",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"13",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"10",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 2.1: Counting Down",
			"9  Subtract the tens place out",
			"but we are not done yet...",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 2.1: Counting Down",
			"9  Adding 5 + 4 back in so first",
			"the 5...  (pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Adding the 4 in to get",
			"9",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"7",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"5",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 2.1: Counting Down",
			"4 but wait now...",
			"(pending opertation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 4 4",
			"Lesson 2.1: Counting Down",
			"Add four to get",
			"4",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"0",
			"Done.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"When subtracting 1 from 10",
			"you take away 10 and add 9.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"When subtracting 1 from 5",
			"you take away 5 and add 4.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 3.1: Addition",
			"This Lesson demonstrates 2 addition problems:",
			"6+5 & 23+9",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 1 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"We Represent 6 by Adding 5...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 3.1: Addition (6+5)",
			"...and 1.",
			"(This is 6)",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (6+5)",
			"Adding th 5 so We Carry to the Previous Column...",
			"(The ten's Column)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 -1 4",
			"Lesson 3.1: Addition (6+5)",
			"...We Reset The Upper-deck and Obtain The Answer.",
			"10 in the Previous Column + 1 in the Current= 11.",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 3.1: Addition",
			"That was a Straight-forward Example...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition",
			"The following one is a bit more complicated.",
			"So, pay attention...",
			"Press Space-bar to Begin",
		}, {
			"0 0 1 2 4",
			"Lesson 3.1: Addition (23+9)",
			"20... (begin to represent 23)",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 3 4",
			"Lesson 3.1: Addition (23+9)",
			"...+3, represents 23.",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (23+9)",
			"Represent 9 as +10 -1.",
			"So, 2 Beads on upper-deck= 10...",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition (23+9)",
			"... -1 (Current-column) completes +9",
			"Resulting in the answer: 32",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To gain proficiency in using the abacus, practice !",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction",
			"This Lesson demonstrates subtracting 7 from 11",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"First Represent 11 as 10...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...and 1.",
			"(This is 11)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction (11-7)",
			"We Represent -7 as -10+3, so...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"-10 ...",
			"(pending operation +3)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 3 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...+3 Completes The Operation",
			"The Answer is +4.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 5.1: Multiplication",
			"This Lesson demonstrates multiplying 23 * 42",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"1 0 1 2 4",
			"Lesson 5.1: Multiplcation (23*42)",
			"First Represent 23 as 20...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"1 0 0 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 3.",
			"(This is 23)",
			"Press Space-bar to Continue",
		}, {
			"2 0 1 4 4",
			"Lesson 5.1: Multiplication (23*42)",
			"We Represent 4 as 40, so...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"2 0 0 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 2.",
			"(This is 42)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*4=12",
			"Add 10 part of 12 as 100",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add 2 part of 12 as 20",
			"(For 12)",
			"Press Space-bar to Continue",
		}, {
			"0 1 0 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*2=6  so add a 5+1",
			"5....",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"... 1 part",
			"(For 6)",
			"Press Space-bar to Continue",
		}, {
			"0 1 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*4=8",
			"Add 800 as 500+300, so add 500 (for 626)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"and add 300",
			"(For 926)",
			"Press Space-bar to Continue",
		}, {
			"0 1 1 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*2=4",
			"So... add 40 (as 50 - 10), so first 50 part",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add -10 part for ...",
			"Result 966",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Using the auxiliary abaci to keep the multiplicands",
			"and using the primary to add up from the results.",
			"Press Space-bar"
}}},
}, {
	/* russianLesson *//* Danish also */
{{{
			"0 0 0 0 4",
			"Lesson1.1: Counting from 1 to 20 for Russian Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"4",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"5",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"7",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"9",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"10",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"10 (pending operation)",
			"Carry-over...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -10 4",
			"Lesson1.1: Counting",
			"10",
			"...Reset deck",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson1.1: Counting",
			"Counting to 10 uses the addition",
			"of the extra carry to the Previous Column",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"13",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"14",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"15",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"18",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"19",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Reset...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -10 4",
			"Lesson1.1: Counting",
			"20 (pending operation)",
			"...Carry-over To The Previous Column.",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -2 4",
			"Lesson1.1: End",
			"And now, some conclusions...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"Each of the 10 beads on the deck has a value of 1.",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Counting 10 beads on the deck requires a carry of",
			"1 bead on the deck of the previous column.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"Every column to the left of one's column is an",
			"order of magnitude greater.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Columns to the right of the one's column are used",
			"for calculations involving decimals.",
			"Press Space-bar"
		}}, {{
			"0 0 0 0 4",
			"Lesson 1.2: Counting by 2's to 30 for Russian Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"2",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"4",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"6",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"8",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"Correct but not done yet...",
			"Press Space-bar",
		}, {
			"0 0 0 -10 4",
			"Lesson 1.2 Counting by 2's",
			"10  ... Hold on...",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"10",
			"OK now we can move on",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"12",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"14",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"16",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"18",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -8 4",
			"Lesson 1.2 Counting by 2's",
			"20  Taking a short cut",
			"Add 2 by taking away 8 and adding 10",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"Now add 10 for",
			"20",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"22",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"24",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"26",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 2 4",
			"Lesson 1.2 Counting by 2's",
			"28",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -8 4",
			"Lesson 1.2 Counting by 2's",
			"30  Short cut again...",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 1.2 Counting by 2's",
			"30  Done!",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 2.1: Counting down from 19 to 0 for Russian Abacus",
			"The beads will move at each step with an",
			"appropriate explanation in this window.",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 2.1: Counting Down",
			"One bead in 10ths column",
			"10 ",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 9 4",
			"Lesson 2.1: Counting Down",
			"Plus 4 beads in ones column",
			"19  ok now we are ready to start",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"Move one bead down to get",
			"18",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"17",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"16",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"15",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"14",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"13",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"12",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"11",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"10",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 2.1: Counting Down",
			"9  Subtract the tens place out",
			"but we are not done yet...",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 9 4",
			"Lesson 2.1: Counting Down",
			"Adding the 9 in to get",
			"9",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"8",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"7",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"5",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"4",
			" ",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"3",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"2",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"1",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -1 4",
			"Lesson 2.1: Counting Down",
			"0",
			"Done.",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion:",
			"When subtracting 1 from 10",
			"you take away 10 and add 9.",
			"Press Space-bar",
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 3.1: Addition",
			"This Lesson demonstrates 2 addition problems:",
			"6+5 & 23+9",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 0 6 4",
			"Lesson 3.1: Addition (6+5)",
			"This is 6.",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (6+5)",
			"Adding the 5 as 10 - 5, Carry to the Previous Column...",
			"(The ten's Column)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 -5 4",
			"Lesson 3.1: Addition (6+5)",
			"And -5... to obtain The Answer.",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 3.1: Addition",
			"That was a Straight-forward Example...",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition",
			"The following one is a bit more complicated.",
			"So, pay attention...",
			"Press Space-bar to Begin",
		}, {
			"0 0 1 2 4",
			"Lesson 3.1: Addition (23+9)",
			"20... (begin to represent 23)",
			"",
			"Press Space-bar",
		}, {
			"0 0 0 3 4",
			"Lesson 3.1: Addition (23+9)",
			"...+3, represents 23.",
			"",
			"Press Space-bar",
		}, {
			"0 0 1 1 4",
			"Lesson 3.1: Addition (23+9)",
			"Represent 9 as +10 -1.",
			"So, 1 Beads on previous  column= 10...",
			"Press Space-bar",
		}, {
			"0 0 0 -1 4",
			"Lesson 3.1: Addition (23+9)",
			"... -1 (Current-column) completes +9",
			"Resulting in the answer: 32",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (continued)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To gain proficiency in using the abacus, practice !",
			"",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction",
			"This Lesson demonstrates subtracting 7 from 11",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"0 0 1 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"First Represent 11 as 10...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...and 1.",
			"(This is 11)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Lesson 4.1: Subtraction (11-7)",
			"We Represent -7 as -10+3, so...",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 -1 4",
			"Lesson 4.1: Subtraction (11-7)",
			"-10 ...",
			"(pending operation +3)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 3 4",
			"Lesson 4.1: Subtraction (11-7)",
			"...+3 Completes The Operation",
			"The Answer is +4.",
			"Press Space-bar",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"To perform addition, move beads towards the",
			"position-beam; to subtract, move beads away from it.",
			"Press Space-bar"
		}}}, {{{
			"0 0 0 0 4",
			"Lesson 5.1: Multiplication",
			"This Lesson demonstrates multiplying 23 * 42",
			"",
			"Press Space-bar to Begin, press q to Exit",
		}, {
			"1 0 1 2 4",
			"Lesson 5.1: Multiplcation (23*42)",
			"First Represent 23 as 20...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"1 0 0 3 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 3.",
			"(This is 23)",
			"Press Space-bar to Continue",
		}, {
			"2 0 1 4 4",
			"Lesson 5.1: Multiplication (23*42)",
			"We Represent 4 as 40, so...",
			"(pending operation)",
			"Press Space-bar to Continue",
		}, {
			"2 0 0 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"...and 2.",
			"(This is 42)",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 1 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*4=12",
			"Add 10 part of 12 as 100",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 2 4",
			"Lesson 5.1: Multiplication (23*42)",
			"Add 2 part of 12 as 20",
			"(For 12)",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 6 4",
			"Lesson 5.1: Multiplication (23*42)",
			"3*2=6  so add a 6",
			"",
			"Press Space-bar to Continue",
		}, {
			"0 0 2 8 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*4=8",
			"Add 800 (for 926)",
			"Press Space-bar to Continue",
		}, {
			"0 0 1 4 4",
			"Lesson 5.1: Multiplication (23*42)",
			"2*2=4  So... add 40 for ...",
			"Result 966",
			"Press Space-bar to Continue",
		}, {
			"0 0 0 0 4",
			"Conclusion: (End)",
			"Using the auxiliary abaci to keep the multiplicands",
			"and using the primary to add up from the results.",
			"Press Space-bar"
}}}}
}};
